#!/bin/bash
# Program:
#       SDK usb initial script
# History:
# 2022/07/20	KimLyu13	First release

# default parameter
acceptVid=(0471 1203  0A5F 0512) #HEX
preName=100
midName="-local.rules"

#1. get user 
userName=$(whoami)
#2. rule file building

#preName=$(($preName+1)) 
fileName=${preName}${midName} 

for vid in "${acceptVid[@]}"
do
    cmd="SUBSYSTEM==\"usb\", ATTRS{idVendor}==\"${vid}\", OWNER=\"${userName}\", GROUP=\"plugdev\",MODE=\"777\""
echo -e "${cmd}" >> $fileName
done

# move rule file to system rule floder
sudo mv $fileName /etc/udev/rules.d/$fileName

#3. add user into plugdev group，and reload udev rules
sudo adduser ${userName} plugdev
sudo udevadm control --reload-rules

#4. indicate info
echo -e "\nPlease RE-Plug usb device!"

# close script
exit 0